# Copyright 2005, @Last Software, Inc.

# This software is provided as an example of using the Ruby interface
# to SketchUp.

# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------

#=============================================================================
# Base class for extensions.  I could have defined separate classes for each
# extension, but for testing this made it a little easier.

class SketchupExtension

    attr_accessor :name, :description, :version, :creator, :copyright

    # REVIEW: Passing the description in as an argument to new makes it hard to use
    # very descriptive descriptions.
    def initialize(name, filePath)
        @name = name
        @description = description
        @path = filePath
        
        @version = "1.0"
        @creator = "@Last Software"
        @copyright = "2005, @Last Software"
    end

    def load
        require @path
    end

end